/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_30_h__
#define __REG_30_h__

/* ***********************************************************************
   *                                                                     *
   * regx30.h                                                            *
   * Tilmann Wendel , BID R&D, 22. Oct. 1997                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * lockable actions are stored in this page                            *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"


#define MERGE_TRCACTION_LOCK(cmd)	CMD_MERGE (CMDG_TRACEACTION_LOCK, cmd)

/* BestTrcRun() */
#define CMDM_TRC_RUN		0x06
#define CMD_TRC_RUN		MERGE_TRCACTION_LOCK (CMDM_TRC_RUN)
#define IN_TRC_RUN		 0
#define OUT_TRC_RUN		 0

/* BestTrcStop() */
#define CMDM_TRC_STOP		0x07
#define CMD_TRC_STOP		MERGE_TRCACTION_LOCK (CMDM_TRC_STOP)
#define IN_TRC_STOP		 0
#define OUT_TRC_STOP		 0

#endif
